package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.OauthClientDetailsEntity;
import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import cn.quantgroup.xyqb.repository.IOauthClientDetailsRepository;
import cn.quantgroup.xyqb.service.user.IOauthClientDetailsService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class OauthClientDetailsServiceImpl implements IOauthClientDetailsService {
    @Autowired
    private final IOauthClientDetailsRepository oauthClientDetailsRepository;
    private final LoadingCache<Integer, OauthClientDetailsEntity> cache;

    public OauthClientDetailsServiceImpl(IOauthClientDetailsRepository oauthClientDetailsRepository) {
        this.oauthClientDetailsRepository = oauthClientDetailsRepository;
        cache = Caffeine.newBuilder()
                .expireAfterWrite(8, TimeUnit.HOURS)
                .maximumSize(1_000)
                .build(this.oauthClientDetailsRepository::findFirstByClientId);

    }


    @Override
    public OauthClientDetailsEntity findFirstByClientId(Integer clientId) {
        return cache.get(clientId);
    }

    @Override
    public List<Integer> findTenantList(List<ProductLoginEntity> productLoginEntityList) {
        List<Integer> tenantList = new ArrayList<>();
        for (ProductLoginEntity ple : productLoginEntityList) {
            OauthClientDetailsEntity oauthClientDetails = oauthClientDetailsRepository.findFirstByInstitutionIdAndProductId(ple.getInstitutionId(), ple.getProductId());
            if (null != oauthClientDetails) {
                tenantList.add(oauthClientDetails.getClientId());
            }
        }
        return tenantList;
    }


}
