package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.enums.Device;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.sql.Timestamp;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/11/23 8:26
 * @description：用户登录信息表
 * @modified By：
 * @version: 1.0
 */
@Data
@Entity
@Table(name = "login_info")
public class LoginInfo extends BaseEntity {


    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "device_id")
    private String deviceId;

    @Column(name = "device")
    private Device device;

    @Column(name = "ip")
    private String ip;

    @Column(name = "is_login")
    private Boolean isLogin;

    @Column(name = "login_fail_msg")
    private String loginFailMsg;

    @Column(name = "is_pass")
    private Boolean isPass;

    @Column(name = "hit_rule")
    private int hitRule;

    @Column(name = "threshold")
    private int threshold;

    @Column(name = "value")
    private int value;


/**
 * CREATE TABLE `login_info` (
 *   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增主键',
 *   `phone_no` varchar(15) NOT NULL COMMENT '手机号',
 *   `device_id` varchar(50) NOT NULL COMMENT '设备ID',
 *   `device` int(2) DEFAULT NULL COMMENT '设备类型(0安卓,1IOS)',
 *   `ip` varchar(30) DEFAULT NULL COMMENT '登录的IP',
 *   `is_login` int(1) DEFAULT '1' COMMENT '是否登录成功',
 *   `is_pass` int(1) DEFAULT '1' COMMENT '是否通过风控策略',
 *   `hit_rule` int(1) DEFAULT '0' COMMENT '命中的规则',
 *   `threshold` int(3) DEFAULT NULL COMMENT '阈值',
 *   `value` int(10) DEFAULT '0' COMMENT '实际的值',
 *   `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间(第一次登陆时间)',
 *   `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
 *   PRIMARY KEY (`id`),
 *   KEY `deviceid_idx` (`device_id`) USING BTREE,
 *   KEY `create_at_idx` (`created_at`) USING BTREE,
 *   KEY `updated_at_idx` (`updated_at`) USING BTREE,
 *   KEY `phone_idx` (`phone_no`) USING BTREE
 * ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='登录信息表';
 */
}
