package cn.quantgroup.xyqb.model;

import java.io.Serializable;

import lombok.Data;

import cn.quantgroup.xyqb.Constants;

/**
 * Created by Miraculous on 15/7/5.
 */
@Data
public class JsonResult<T> implements Serializable {

    private static final long serialVersionUID = -1L;

    private static final Long SUCCESS_CODE = 0L;

    private static final Long ERROR_STATE_CODE = 1L;

    private static final Long SUCCESS_BUSSINESS_CODE = 0L;

    private static final Long ERROR_BUSSINESS_CODE = 1L;

    private String msg = "";

    // 0成功，1失败
    private String code = Constants.SUCCESS_CODE;

    // 业务错误码
    private String businessCode = Constants.SUCCESS_CODE;

    private T data = null;

    public JsonResult() {
    }

    public JsonResult(T data) {
        this.data = data;
    }

    /**
     * @param msg
     * @param code
     * @param data
     */
    public JsonResult(String msg, Long code, T data) {
        this.msg = msg;
        this.code = String.format(Constants.ZERO_FILL_TEMPLATE, code);
        this.data = data;
    }

    public JsonResult(String msg, Long code, T data, Long businessCode) {
        this.msg = msg;
        this.code = String.format(Constants.ZERO_FILL_TEMPLATE, code);
        this.data = data;
        this.businessCode = String.format(Constants.ZERO_FILL_TEMPLATE, businessCode);
    }

    /**
     * 构造成功的JsonResult
     *
     * @param msg  String
     * @param data Object
     * @return JsonResult
     */
    public static<T> JsonResult<T> buildSuccessResult(String msg, T data) {
        return new JsonResult(msg, SUCCESS_CODE, data, SUCCESS_BUSSINESS_CODE);
    }

    public static<T> JsonResult<T> buildSuccessResult(String msg, T data, Long businessCode) {
        return new JsonResult(msg, SUCCESS_CODE, data, businessCode);
    }

    public static<T> JsonResult<T> buildSuccessResult(String msg) {
        return new JsonResult(msg, SUCCESS_CODE, null, SUCCESS_BUSSINESS_CODE);
    }

    public static<T> JsonResult<T> buildSuccessResult() {
        return new JsonResult<>(null, SUCCESS_CODE, null, SUCCESS_BUSSINESS_CODE);
    }

    public static<T> JsonResult<T> buildSuccessResultGeneric(T data) {
        return new JsonResult<>(null, SUCCESS_CODE, data, SUCCESS_BUSSINESS_CODE);
    }

    /**
     * 构造状态不正确的JsonResult
     *
     * @param msg  String
     * @param data Object
     * @return JsonResult
     */
    public static<T> JsonResult<T> buildErrorStateResult(String msg, T data) {
        return new JsonResult(msg, SUCCESS_CODE, data, ERROR_BUSSINESS_CODE);
    }

    public static<T> JsonResult<T> buildErrorStateResult(String msg, T data, Long businessCode) {
        return new JsonResult(msg, SUCCESS_CODE, data, businessCode);
    }

    public static<T> JsonResult<T> buildFatalErrorStateResult(String msg, T data, Long businessCode) {
        return new JsonResult(msg, ERROR_STATE_CODE, data, businessCode);
    }
    public static<T> JsonResult<T> buildErrorResultWhithCode(String msg,  String businessCode) {
        JsonResult jsonResult = new JsonResult();
        jsonResult.setBusinessCode(businessCode);
        jsonResult.setCode(String.format(Constants.ZERO_FILL_TEMPLATE, SUCCESS_CODE));
        jsonResult.setMsg(msg);
        return jsonResult;
    }

    /**
     * 判断当前JsonResult是否是成功
     *
     * @return true=是成功,false=失败
     */
    public boolean isSuccess() {
        boolean codeSuccess = String.format(Constants.ZERO_FILL_TEMPLATE, SUCCESS_CODE).equals(this.getCode());
        boolean bussSuccess = String.format(Constants.ZERO_FILL_TEMPLATE, SUCCESS_BUSSINESS_CODE).equals(this.getBusinessCode());
        return bussSuccess && codeSuccess;
    }

    @Override
    public String toString() {
        return "JsonResult{" +
                "businessCode='" + businessCode + '\'' +
                ", code='" + code + '\'' +
                ", msg='" + msg + '\'' +
                ", data=" + data +
                '}';
    }

}
