package cn.quantgroup.xyqb.service.session;

import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;

/**
 * Created by 11 on 2016/12/28.
 */
public interface ISessionService {

  /**
   * 更新session
   * 用户信息存在,更新session中的最后访问时间,重新写入缓存.
   * 存在则保存用户session信息,userId为uuid
   *
   * @param channelId
   * @param createdFrom
   * @param appChannel
   * @param user
   * @param merchant
   * @return
   */
  AuthBean createSession(Long channelId, Long createdFrom, String appChannel, User user, Merchant merchant);

  SessionStruct createSessionAndPersist(User user, LoginProperties loginProperties);

  String findSessionIdByUserIdLoginProperties(Long userId, LoginProperties properties);

  String findSessionValueBySessionId(String sessionId);

  SessionStruct newSession(User user, LoginProperties properties);

  void persistSession(String token, SessionValue sessionValue);

  SessionStruct findSessionBySessionId(String sessionId);

  void deleteByUserId(long userId);

  void deleteUserCatch(User user);
}
