package cn.quantgroup.xyqb.service.api.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserFullInfo;
import cn.quantgroup.xyqb.model.model.BlacklistMatchResult;
import cn.quantgroup.xyqb.service.api.IUserApiService;
import cn.quantgroup.xyqb.service.model.IModelService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * Created by FrankChow on 15/12/16.
 */
@Service
public class UserApiServiceImpl implements IUserApiService {

    @Autowired
    private IModelService modelService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserDetailService userDetailService;


    @Override
    public boolean userImportCheck(String phoneNo) {
        User user = userService.findByPhoneWithCache(phoneNo);

        if (user != null) {
            return false;
        }

        BlacklistMatchResult blacklistMatchResult = modelService.getBlacklistMatchResult(phoneNo);
        if (blacklistMatchResult == null) {
            return true;
        }
        return !blacklistMatchResult.getFlag();
    }

    @Override
    public Optional<UserFullInfo> getUserFullInfoByUuid(String uuid) {
        User user = userService.findByUuidWithCache(uuid);
        if (null == user) {
            return Optional.empty();
        }
        UserDetail detail = userDetailService.findByUserId(user.getId());
        UserFullInfo userFullInfo = new UserFullInfo(user, detail);
        return Optional.of(userFullInfo);
    }

    @Override
    public Optional<UserFullInfo> getUserFullInfoByPhone(String phoneNo) {
        User user = userService.findByPhoneInDb(phoneNo);
        if (null == user) {
            return Optional.empty();
        }
        UserDetail detail = userDetailService.findByUserId(user.getId());
        UserFullInfo userFullInfo = new UserFullInfo(user, detail);
        return Optional.of(userFullInfo);
    }
}
