package cn.quantgroup.xyqb.entity;


import cn.quantgroup.xyqb.entity.enums.Device;
import lombok.Data;
import lombok.ToString;

import javax.persistence.*;

/**
 * 查询营销短信统计信息
 *
 * @author renwc
 * @date 2020-07-14
 */
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "LoginInfo.countByPhoneAndDevice",
                        query = "select count(DISTINCT device_id) num ,device from  login_info where phone_no=?1 and device =?2 and  created_at > DATE_ADD(CURRENT_TIMESTAMP(),INTERVAL -90 DAY)  group by device",
                        resultClass = CountDevice.class
                )
        }
)
@Data
@ToString
@Entity
public class CountDevice {

    @Id
    @Column(name = "device")
    private Device device;


    @Column(name = "num")
    private Long num;
}
