package cn.quantgroup.xyqb.controller.middleoffice.common;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.DataException;
import cn.quantgroup.xyqb.util.BctyptPasswordUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import java.util.Objects;
import org.springframework.stereotype.Component;

/**
 * 密码校验策略
 */
@Component
public class PwdVerifyStrategy implements IVerifyStrategy {
    @Override
    public VerifyTypeEnum strategyName() {
        return VerifyTypeEnum.pwd;
    }

    @Override
    public void verify(User user, String verify) {
        // 如果新加密的密码不为空校验新密码
        String cipherPassword = user.getCipherPassword();
        if (!"".equals(cipherPassword)) {
            if (Objects.equals(cipherPassword, BctyptPasswordUtil.BCryptWithSalt(verify))) {
                return;
            }
            throw new DataException("用户名或密码错误");
        }
        // 否则校验旧的密码
        String password = user.getPassword();
        if (Objects.equals(password, PasswordUtil.MD5WithSalt(verify))) {
            return;
        }
        //todo 自定义异常
        throw new DataException("用户名或密码错误");
    }
}
