package cn.quantgroup.xyqb.controller.internal.platform;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.MerchantConfig;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.Tuple;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.page.IPageService;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by Miraculous on 2017/1/3.
 */
@RestController
@RequestMapping("/platform/api")
public class PlatformAPIController implements IBaseController {


  private static final Logger LOGGER = LoggerFactory.getLogger(PlatformAPIController.class);

  @Autowired
  private IPageService pageService;
  @Autowired
  private IMerchantService merchantService;

  @RequestMapping("/page/return_url")
  public JsonResult returnUrl(String key) {
    Merchant merchant = merchantService.findMerchantByName(key);
    if (null == merchant) {
      return JsonResult.buildErrorStateResult("", null);
    }
    MerchantConfig config = merchantService.findConfigByMerchantIdAndConfigName(merchant.getId(), "returnUrl");
    if (null == config) {
      return JsonResult.buildSuccessResult("", null);
    }
    return JsonResult.buildSuccessResult("", config.getConfigValue());
  }

  @RequestMapping("/page/next")
  public JsonResult nextPage(String key, String target, @RequestParam(required = false, defaultValue = "") String currentPage) {
    User user = getCurrentUserFromRedis();
    if (null == user) {
      return JsonResult.buildErrorStateResult("未找到用户", null);
    }
    Tuple<String, Boolean> nextPageTuple = pageService.nextPage(user, target, currentPage);
    Boolean isFinal = nextPageTuple.getValue();
    String nextPage = nextPageTuple.getKey();
    if(key.equals("xyqb")){
      MerchantConfig merchantConfig = merchantService.findConfigByMerchantIdAndConfigName(4L, "returnUrl");
      return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "external", "transition", merchantConfig.getConfigValue()));
    }
    if (isFinal) {
      Merchant merchant = merchantService.findMerchantByName(key);
      if (merchant == null) {
        return JsonResult.buildSuccessResult("", null);
      }
      MerchantConfig merchantConfig = merchantService.findConfigByMerchantIdAndConfigName(merchant.getId(), "returnUrl");
      if (merchantConfig == null) {
        return JsonResult.buildSuccessResult("", null);
      }
      return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "external", "transition", merchantConfig.getConfigValue()));
    }
    if (StringUtils.isEmpty(nextPage)) {
      return JsonResult.buildErrorStateResult("", null);
    }
    return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "user", "transition", nextPage));
  }


}
