package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserQueryLog;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by 11 on 2016/12/30.
 */
public interface IUserQueryLogRepository extends JpaRepository<UserQueryLog, Long> {

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(nativeQuery = true, value = "select * from user_query_log ul where created_At between ?1 and ?2  limit ?3 ,?4 ")
    List<UserQueryLog> findQueryLogCreatedAt(Date beginDate, Date endDate, Integer pageId, Integer pageSize);

    @Query(nativeQuery = true, value = "select count(1) from user_query_log ul where created_At between ?1 and ?2 ")
    Long findQueryLogCountCreatedAt(Date beginDate, Date endDate);
}
