package cn.quantgroup.xyqb.controller.external.motan;

import cn.quantgroup.bean.*;
import cn.quantgroup.service.*;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.session.*;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Random;

/**
 * Created by 11 on 2017/2/27.
 */
@MotanService(export = "userMotan:8002", registry="registryConfig")
public class MotanUserServiceImpl implements UserMotanService, IBaseController{

    private static final Logger LOGGER = LoggerFactory.getLogger(MotanUserServiceImpl.class);

    private static final ObjectMapper MAPPER = new ObjectMapper();
    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Autowired
    private IIdCardService idCardService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserDetailService userDetailService;
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private ISmsService smsService;
    @Autowired
    private ILkbUserService lkbUserService;
    @Autowired
    private IMerchantService merchantService;
    @Autowired
    private ISessionService sessionService;
    private final static Random random = new Random();

    @Override
    public UserSysResult<XUser> findUserByPhoneNo(String phoneNo) {
        User user = userService.findByPhoneInDb(phoneNo);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUser> findUserByUuid(String uuid) {
        User user = userService.findByUuidInDb(uuid);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUser> saveUser(UserBean userBean) {
        UserSysResult<XUser> result = new UserSysResult<>();
        if(null == userBean) {
            result.setCode("0001");
            result.setBusinessCode("0001");
            result.setMsg("要保存的用户对象不能为null");
            result.setData(null);
            return result;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        User user = new User();
        user.setCreatedAt(now);
        user.setUpdatedAt(now);
        user.setUuid(userBean.getUuid());
        user.setPhoneNo(userBean.getPhoneNo());
        user.setEnable(true);
        user.setPassword(userBean.getPassword());
        user.setRegisteredFrom(userBean.getRegisteredFrom());
        User saveUser = userService.saveUser(user);
        XUser xUser = convertObject(JSON.toJSONString(saveUser), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUserDetail> findUserDetailByUserId(Long userId) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUser>() {});
        return returnValue(xUserDetail, "");
    }

    @Override
    public UserSysResult<XUser> findUserByUserId(Long id) {
        User user = userService.findById(id);
        XUser xUser = convertObject(JSON.toJSONString(user), new TypeReference<XUser>() {});
        return returnValue(xUser, "");
    }

    @Override
    public UserSysResult<XUserDetail> findUserDetailByPhone(String phoneNo) {
        UserDetail userDetail = userDetailService.findByPhoneNo(phoneNo);
        XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUserDetail>() {});
        return returnValue(xUserDetail, "");
    }

    @Override
    public UserSysResult<XUserDetail> saveUserDetail(UserDetailUpdateBean userDetailUpdateBean) {
        UserSysResult<XUserDetail> result = new UserSysResult<>();
        result.setCode("0001");
        result.setBusinessCode("0001");
        if(null == userDetailUpdateBean) {
            result.setMsg("要保存的用户详情对象不能为null");
            result.setData(null);
            return result;
        }
        UserDetail userDetail = new UserDetail();
        if(null != userDetailUpdateBean.getId() && userDetailUpdateBean.getId() > 0L) {
            userDetail.setId(userDetailUpdateBean.getId());
        }
        userDetail.setUserId(userDetailUpdateBean.getUserId());
        userDetail.setName(userDetailUpdateBean.getName());
        userDetail.setPhoneNo(userDetailUpdateBean.getPhoneNo());
        userDetail.setIdNo(userDetailUpdateBean.getIdNo());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        userDetail.setCreatedAt(time);
        userDetail.setUpdatedAt(time);
        userDetail.setIdType(IdType.ID_CARD);
        try {
            userDetail.setGender(idCardService.getIdCardInfo(userDetailUpdateBean.getIdNo()).getGender());
        } catch (ParseException e) {
            LOGGER.error("根据身份证获取性别出错,错误信息:" + e);
            result.setMsg("根据身份证获取性别出错.");
            return result;
        }
        userDetail.setEmail(userDetailUpdateBean.getEmail());
        userDetail = userDetailService.saveUserDetail(userDetail);
        if(userDetail != null){
            XUserDetail xUserDetail = convertObject(JSON.toJSONString(userDetail), new TypeReference<XUserDetail>() {});
            return returnValue(xUserDetail, "");
        }
        result.setMsg("");
        return result;
    }

    @Override
    public UserSysResult<XLoginInfo> getLoginInfo(String s) {
        SessionStruct sessionStruct = getSessionStruct();
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUser(UserRet.getUserRet(sessionStruct.getValues().getUser()));
        loginInfo.setToken(sessionStruct.getSid());
        LoginInfo.LoginContext context = new LoginInfo.LoginContext();
        context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
        context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
        context.setAppChannel(sessionStruct.getValues().getLoginProperties().getAppChannel());
        loginInfo.setLoginContext(context);
        XLoginInfo xLoginInfo = LoginInfo.getXLoginInfo(loginInfo);
        return returnValue(xLoginInfo, "");
    }

    @Override
    public UserSysResult<XLoginInfo> appLoginAndFetchLoginInfo(AppLoginParam appLoginParam, HttpServletRequest request) {
        UserSysResult<XLoginInfo> userSysResult = returnValue(null, "");
        if (!ValidationUtil.validatePhoneNo(appLoginParam.getPhoneNo())) {
            userSysResult.setMsg("该用户名不存在，<br/>请重新输入或注册新账号。");
            return userSysResult;
        }

        String requestIp = IPUtil.getRemoteIP(request);
        LOGGER.info("第三方用户登录, loginFrom:{}, requestIp:{}", appLoginParam.getRegisterFrom(), requestIp);
        User user = userService.findByPhoneInDb(appLoginParam.getPhoneNo());
        if (user == null) {
            user = register(appLoginParam.getRegisterFrom(), appLoginParam.getPhoneNo(), appLoginParam.getIdNo(), appLoginParam.getName());
        }
        if (user == null) {
            userSysResult.setMsg("该用户名不存在，<br/>请重新输入或注册新账号。");
            return userSysResult;
        }
        Merchant merchant = merchantService.findMerchantByName(appLoginParam.getKey());
        if (merchant == null) {
            userSysResult.setMsg("无效的商户");
            return userSysResult;
        }
        LoginProperties loginProperties = new LoginProperties();
        loginProperties.setChannelId(appLoginParam.getChannelId());
        loginProperties.setMerchantName(merchant.getName());
        loginProperties.setCreatedFrom(appLoginParam.getRegisterFrom());
        loginProperties.setAppChannel(appLoginParam.getAppChannel());
        SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);

        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUser(UserRet.getUserRet(user));
        loginInfo.setToken(sessionStruct.getSid());
        LoginInfo.LoginContext context = new LoginInfo.LoginContext();
        context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
        context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
        context.setAppChannel(appLoginParam.getAppChannel());
        loginInfo.setLoginContext(context);

        LOGGER.info("第三方用户获取信息登录成功, loginFrom:{}, phoneNo:{},appChannel:{}", appLoginParam.getRegisterFrom(), appLoginParam.getPhoneNo(), appLoginParam.getAppChannel());
        XLoginInfo xLoginInfo = convertObject(JSON.toJSONString(loginInfo), new TypeReference<XLoginInfo>() {});
        return returnValue(xLoginInfo, "");
    }

    private <T> T convertObject(String json, TypeReference typeReference) {
        try {
            if(StringUtils.isEmpty(json)) {
                return null;
            }
            return MAPPER.readValue(json, typeReference);
        }catch (Exception ex) {
            LOGGER.error("用户信息转换出错,错误信息{}", ex);
            return null;
        }

    }

    /**
     * 封装返回结果.
     * @param t
     * @param message
     * @param <T>
     * @return
     */
    private <T> UserSysResult<T> returnValue(T t, String message) {
        UserSysResult<T> userSysResult = new UserSysResult();
        userSysResult.setMsg(message);
        /**
         * 无返回结果时,返回的code和BusinessCode均是0001
         */
        if(null == t) {
            userSysResult.setData(null);
            userSysResult.setBusinessCode("0001");
            userSysResult.setCode("0001");
        } else {
            userSysResult.setData(t);
            userSysResult.setBusinessCode("0000");
            userSysResult.setCode("0000");
        }
        return userSysResult;
    }

    /**
     * 注册新用户
     *
     * @return
     */
    private User register(Long registerFrom, String phoneNo, String idNo, String name) {

        String randomCode = String.valueOf(random.nextInt(899999) + 100000);

        String uuid = lkbUserService.registerApp(phoneNo, randomCode);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());

        LOGGER.info("第三方登录用户，保存 User");

        User user = new User();
        user.setRegisteredFrom(registerFrom);
        user.setUuid(uuid);
        user.setEnable(true);
        user.setPhoneNo(phoneNo);
        user.setPassword(PasswordUtil.MD5(randomCode + Constants.PASSWORD_SALT));
        user.setUpdatedAt(currentTime);
        user.setCreatedAt(currentTime);
        userRepository.saveAndFlush(user);

        if(registerFrom != 645L) {
            smsService.sendAfterRegister(phoneNo);
            LOGGER.info("第三方登录用户注册成功, registerFrom:{}, phoneNo:{}, 并且已发送短信通知", registerFrom, phoneNo);
        }

        if (org.apache.commons.lang3.StringUtils.isNotEmpty(idNo) && org.apache.commons.lang3.StringUtils.isNotEmpty(name)) {
            LOGGER.info("第三方登录用户，保存 UserDetail");

            IdCardInfo cardInfo;
            try {
                cardInfo = idCardService.getIdCardInfoWithExceptions(idNo);

                UserDetail userDetail = new UserDetail();
                userDetail.setIdNo(cardInfo.getIdNo());
                userDetail.setPhoneNo(phoneNo);
                userDetail.setName(name);
                userDetail.setIdType(IdType.ID_CARD);
                userDetail.setCreatedAt(currentTime);
                userDetail.setUpdatedAt(currentTime);
                userDetail.setUserId(user.getId());
                userDetail.setGender(cardInfo.getGender());
                userDetailService.saveUserDetail(userDetail);

                lkbUserService.userUpdate(user.getUuid(), name, idNo);
            } catch (Exception e) {
                LOGGER.error("保存 UserDetail 出现异常", e);
            }
        }

        return user;
    }
}
