package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.converter.EncryptConverter;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang.StringUtils;

/**
 * Created by Miraculous on 15/7/4.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user",
       uniqueConstraints = @UniqueConstraint(columnNames = "phone_no"))
public class User extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -1L;

    //手机号
    @Column(name = "phone_no")
    private String phoneNo;

    //uuid
    @Column(name = "password")
    private String password;

    //第一次用户来源 channel_id
    @Column(name = "registered_from")
    private Long registeredFrom;

    //uuid
    @Column(name = "uuid")
    private String uuid;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "encrypted_phone_no")
    @Convert(converter = EncryptConverter.class)
    private String encryptedPhoneNo;

    @Column(name = "cipher_password")
    private String cipherPassword;

    public String getEncryptedPhoneNo() {
        return StringUtils.isBlank(encryptedPhoneNo) ? phoneNo : encryptedPhoneNo;
    }

    public String getPhoneNo() {
        return StringUtils.isBlank(encryptedPhoneNo) ? phoneNo : encryptedPhoneNo;
    }

    /**
     * 是否有密码
     *
     * @return
     */
    public boolean getHasPassword() {
        return Objects.nonNull(password) && !Objects.equals("", password);
    }

}
