package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.util.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Created by liqing on 2017/12/4 0004.
 * 注册 - 发送短信
 * 失败不影响注册流程
 */
@Component("smsUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class SmsUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private ISmsService smsService;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) {
        try {
            doHandleSmsUserRegister(userRegisterParam);
        } catch (Exception e) {
            // 发送短信失败不影响注册流程
            log.error("[exception][smsUserRegisterHandler_exception]userRegisterParam={},error={}",
                    JsonUtil.toJson(userRegisterParam), e);
        }
        if (successor != null) {
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

    /**
     * 执行发送短信
     *
     * @param userRegisterParam
     */
    private void doHandleSmsUserRegister(UserRegisterParam userRegisterParam) {
        // 发送注册成功短信
        try {
            //doHandleSendSuccessSms(userRegisterParam);
        } catch (Exception e) {
            // 发送短信失败不影响注册流程
            log.error("[exception][smsUserRegisterHandler_doHandleSendSuccessSms_exception]userRegisterParam={},error={}",
                    JsonUtil.toJson(userRegisterParam), e);
        }
        // 发送推送app短信
        try {
            doHandleSendAppSms(userRegisterParam);
        } catch (Exception e) {
            // 发送短信失败不影响注册流程
            log.error("[exception][smsUserRegisterHandler_doHandleSendAppSms_exception]userRegisterParam={},error={}",
                    JsonUtil.toJson(userRegisterParam), e);
        }
    }

    /**
     * 执行发送推送app短信 TODO
     *
     * @param userRegisterParam
     */
    private void doHandleSendAppSms(UserRegisterParam userRegisterParam) {
        if (!userRegisterParam.isSendAppSms()) {
        }
    }

    /**
     * 执行发送注册成功短信
     *
     * @param userRegisterParam
     */
    private void doHandleSendSuccessSms(UserRegisterParam userRegisterParam) {
        if (!userRegisterParam.isSendSuccessSms()) {
            return;
        }
        Long registerFrom = userRegisterParam.getRegisterFrom();
        String phoneNo = userRegisterParam.getPhoneNo();
        if (registerFrom != 645L && registerFrom != 900L && registerFrom != 158412L) {
            smsService.sendAfterRegister(phoneNo);
            log.info("第三方登录用户注册成功,registerFrom:{}, phoneNo:{},并且已发送短信通知", registerFrom, phoneNo);
        } else if (registerFrom == 900L) {
            smsService.sendAfterRegister(phoneNo, "123");
            log.info("第三方(聚美)登录用户注册成功,registerFrom:{},phoneNo:{},并且已发送短信通知", registerFrom, phoneNo);
        }
    }

}
