package cn.quantgroup.xyqb.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import java.io.StringWriter;

/**
 * XML <=> Object
 *
 * @author mengfan.feng
 * @time 2015-07-25 18:47
 */
@SuppressWarnings("unchecked")
public class XmlUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);

    /**
     * Disable new
     */
    private XmlUtil() {
    }

    /**
     * Object => XML
     *
     * @param obj
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> String xml(Object obj, Class<T> clazz) {
        return doXml(obj, clazz, "UTF-8", false);
    }

    /**
     * Object => XML
     *
     * @param obj
     * @param clazz
     * @param charset
     * @param <T>
     * @return
     */
    public static <T> String xml(Object obj, Class<T> clazz, String charset) {
        return doXml(obj, clazz, charset, false);
    }

    /**
     * Object => XML pretty
     *
     * @param obj
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> String xmlPretty(Object obj, Class<T> clazz) {
        return doXml(obj, clazz, "UTF-8", true);
    }

    /**
     * Object => XML pretty
     *
     * @param obj
     * @param clazz
     * @param charset
     * @param <T>
     * @return
     */
    public static <T> String xmlPretty(Object obj, Class<T> clazz, String charset) {
        return doXml(obj, clazz, charset, true);
    }

    /**
     * Object => XML
     *
     * @param obj
     * @param clazz
     * @param pretty
     * @param <T>
     * @return
     */
    private static <T> String doXml(Object obj, Class<T> clazz, String charset, boolean pretty) {
        if (obj == null || clazz == null) {
            return null;
        }

        StringWriter writer = null;
        try {
            JAXBContext context = JAXBContext.newInstance(clazz);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_ENCODING, charset);
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, pretty);
            writer = new StringWriter();
            marshaller.marshal(obj, writer);
            return writer.toString();
        } catch (Exception e) {
            LOGGER.error("Parse Object to XML error\nXML:{}\nClass<T>:{}", obj.getClass().getName(), clazz.getName(), e);
            return null;
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (Exception e) {
                    LOGGER.error("Close Writer error", e);
                }
            }
        }
    }
}
