package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserDetail;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * Created by 11 on 2016/12/20.
 */
@Data
public class UserDetailRet implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long id;

    private Long userId;

    private String phoneNo;

    private String name;

    //证件号
    private String idNo;

    //0 身份证 1 军官证 2 护照
    private IdType idType;

    //身份证验真 0 未认证 1认证
    private Boolean isAuthenticated = false;

    //0 未知 1 女 2 男
    private Gender gender;

    private String email;

    private String qq;

    //创建时间
    private Long createdAt;

    //上一次修改时间
    private Long updatedAt;

    /**
     * 转换时间从timestamp到long
     *
     * @param userDetail
     * @return return self
     */
    public static UserDetailRet getUserDetail(UserDetail userDetail) {
        long createTimeStamp = userDetail.getCreatedAt().getTime();
        long updateTimeStamp = userDetail.getUpdatedAt().getTime();
        UserDetailRet userDetailRet = new UserDetailRet();
        userDetailRet.setId(userDetail.getId());
        userDetailRet.setName(userDetail.getName());
        userDetailRet.setPhoneNo(userDetail.getPhoneNo());
        userDetailRet.setEmail(StringUtils.defaultIfEmpty(userDetail.getEmail(), ""));
        userDetailRet.setGender(userDetail.getGender());
        userDetailRet.setIsAuthenticated(userDetail.getIsAuthenticated());
        userDetailRet.setQq(StringUtils.defaultIfEmpty(userDetail.getQq(), ""));
        userDetailRet.setUserId(userDetail.getUserId());
        userDetailRet.setCreatedAt(createTimeStamp);
        userDetailRet.setUpdatedAt(updateTimeStamp);
        return userDetailRet;
    }

}
