package repsitory;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.repository.IUserAuthorizedRepository;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import demo.BaseParametersTests;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.domain.Example;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;

/**
 * 业务层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@Rollback
@Transactional
@RunWith(value = Parameterized.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class UserAuthorizedRepsitoryTests extends BaseParametersTests {

    @Resource
    private IUserAuthorizedRepository userAuthorizedRepository;

    UserAuthorized obj = new UserAuthorized();
    public UserAuthorizedRepsitoryTests(Long userId, String idNo, String name, AuthPattern authPattern, Boolean available) {
        obj.setUserId(userId);
        obj.setIdNo(idNo);
        obj.setName(name);
        obj.setAuthPattern(authPattern);
        obj.setAvailable(available);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {1L,"350504198805144101","史书一", AuthPattern.ZMXY, true},
                {10L,"350504198805144102","史书二", AuthPattern.ZMXY, true},
                {20L,"350504198805144103","史书三", AuthPattern.FOUR_ELEMENTS_OF_BANK_CARD, true},
                {1L, "IDNO-1", "王-1", AuthPattern.ZMXY, true}
        };
        return Arrays.asList(data);
    }

    @Test
    public void testExist() throws Exception {
        log.info("testExist: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        UserAuthorized obj = new UserAuthorized();
        boolean exist = userAuthorizedRepository.exists(Example.of(obj));
        Assert.assertNotNull(obj);
    }

    @Test
    public void testSave() throws Exception {
        log.info("testSave: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        UserAuthorized obj = new UserAuthorized();
        obj = userAuthorizedRepository.save(obj);
        Assert.assertNotNull(obj);
    }

    @Test
    public void testQuery(){
        log.info("testQuery: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        UserAuthorized obj = userAuthorizedRepository.findByIdNo(this.obj.getIdNo());
        Assert.assertNotNull(obj);
    }

}
