package cn.quantgroup.xyqb.event.jr58;

import cn.quantgroup.cloudconfig.SafeValue;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

@Service
public class Jr58MessageSigner {

    private PrivateKey generatedSigningKey;

    @SafeValue("jr58.sign.key")
    private String signingKeySpec;

    @PostConstruct
    private void init() throws Exception {

        if (StringUtils.isEmpty(signingKeySpec)) return;

        byte[] keyBytes = Base64.getDecoder().decode(signingKeySpec);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);

        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        generatedSigningKey = keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public String sign(String s) throws Exception {
        if (generatedSigningKey == null) return "";

        byte[] data = s.getBytes();

        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(generatedSigningKey);
        signature.update(data);

        byte[] signedBytes = signature.sign();
        return Base64.getEncoder().encodeToString(signedBytes);
    }
}
