package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.model.Gender;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;

/**
 * Created by FrankChow on 15/7/8.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user_detail",
       uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
public class UserDetail extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "name")
    private String name;

    //身份证验真 0 未认证 1认证
    @Column(name = "is_authenticated")
    private Boolean isAuthenticated = false;

    //0 未知 1 女 2 男
    @Column(name = "gender")
    private Gender gender;

    @Column(name = "email")
    private String email;

    @Column(name = "qq")
    private String qq;
}
