package cn.quantgroup.xyqb.entity.converter;

import cn.quantgroup.security.AESEncryption;
import cn.quantgroup.xyqb.util.ApplicationContextHolder;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 * 字段加解密转换器
 *
 * @author killer
 * @date 2022年01月04日
 **/
@Converter
public class EncryptConverter implements AttributeConverter<String, String>  {

    @Override
    public String convertToDatabaseColumn(String entityAttribute) {
        /* 加密 */
        if (StringUtils.isBlank(entityAttribute)) {
            return entityAttribute;
        }
        AESEncryption aesEncryption = ApplicationContextHolder.getBean(AESEncryption.class);
        return aesEncryption.encryptBase64(entityAttribute);
    }

    @Override
    public String convertToEntityAttribute(String databaseColumn) {
        /* 解密 */
        if (StringUtils.isBlank(databaseColumn)) {
            return databaseColumn;
        }
        AESEncryption aesEncryption = ApplicationContextHolder.getBean(AESEncryption.class);
        return aesEncryption.decryptBase64(databaseColumn);
    }
}
