package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserQueryLog;
import cn.quantgroup.xyqb.repository.IUserQueryLogRepository;
import cn.quantgroup.xyqb.service.user.IUserQueryLogService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by zenglibin on 2017/06/13.
 */
@Service
public class UserQueryLogServiceImpl implements IUserQueryLogService {

    @Autowired
    private IUserQueryLogRepository userQueryLogRepository;

    @Override
    public List<UserQueryLog> findByTimestamp(Date beginDate, Date endDate, Integer pageId, Integer pageSize) {
        return userQueryLogRepository.findQueryLogCreatedAt(beginDate, endDate, pageId, pageSize);
    }

    @Override
    public Long findByTimestampCount(Date beginDate, Date endDate) {
        return userQueryLogRepository.findQueryLogCountCreatedAt(beginDate, endDate);
    }

    @Override
    public UserQueryLog save(UserQueryLog userQueryLog) {
        return userQueryLogRepository.save(userQueryLog);
    }

}
