package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import java.util.Locale;
import javax.annotation.Resource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class QuantgroupCaptchaServiceTest {
    @Resource
    private IQuantgroupCaptchaService quantgroupCaptchaService;

    @Test
    public void testFetchQuantgroupCaptcha(){
        Locale locale = Locale.US;
        Assert.assertNotNull(quantgroupCaptchaService.fetchQuantgroupCaptcha(locale));
    }


    @Test
    public void testValidQuantgroupCaptcha(){
        String captchaId="b233ed97-02b7-4b85-9c1b-bfc2729682a4";
        String captchaValue="0000";
        Assert.assertFalse(quantgroupCaptchaService.validQuantgroupCaptcha(captchaId,captchaValue));
    }

}
