package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.model.webchat.WechatEventMsg;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;

/**
 * 微信用户绑定信息创建或更新事件
 *
 * @author ag
 */
@Getter
@Setter
public class WechatBindEvent extends ApplicationEvent {
    private WechatEventMsg wechatEventMsg;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public WechatBindEvent(Object source) {
        super(source);
    }

    public WechatBindEvent(Object source, WechatEventMsg wechatEventMsg) {
        super(source);
        this.wechatEventMsg = wechatEventMsg;
    }
}
