package cn.quantgroup.xyqb.controller.external.platform;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.MerchantConfig;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.Tuple;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.page.IPageService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by Miraculous on 2017/1/3.
 */
@RestController
@RequestMapping("/platform/api")
public class PlatformApiController implements IBaseController {

    @Autowired
    private IPageService pageService;
    @Autowired
    private IMerchantService merchantService;
    @Autowired
    private IUserDetailService userDetailService;

    @Value("${merchant.config.returnUrl}")
    private String merchantConfigReturnUrl;

    @RequestMapping("/page/return_url")
    public JsonResult returnUrl(String key) {
        Merchant merchant = merchantService.findMerchantByName(key);
        if (null == merchant) {
            return JsonResult.buildErrorStateResult("", null);
        }
//        MerchantConfig config = merchantService.findConfigByMerchantIdAndConfigName(merchant.getId(), "returnUrl");
        if (merchantConfigReturnUrl == null) {
            return JsonResult.buildSuccessResult("", null);
        }
        String configValue = merchantConfigReturnUrl.split(",")[4];
        if (null == configValue) {
            return JsonResult.buildSuccessResult("", null);
        }
        return JsonResult.buildSuccessResult("", configValue);
    }

    @RequestMapping("/page/next")
    public JsonResult nextPage(String key, String target, @RequestParam(required = false, defaultValue = "") String currentPage) {
        User user = getCurrentUserFromRedis();
        if (null == user) {
            return JsonResult.buildErrorStateResult("未找到用户", null);
        }
        Tuple<String, Boolean> nextPageTuple = pageService.nextPage(user, target, currentPage);
        Boolean isFinal = nextPageTuple.getValue();
        String nextPage = nextPageTuple.getKey();
        if (Constants.PAGE_NEXT_KEY_XYQB.equals(key)) {
//            MerchantConfig merchantConfig = merchantService.findConfigByMerchantIdAndConfigName(4L, "returnUrl");
            if (merchantConfigReturnUrl == null) {
                return JsonResult.buildSuccessResult("", null);
            }
            String configValue = merchantConfigReturnUrl.split(",")[4];
            return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "external", "transition", configValue));
        }
        if (isFinal) {
            Merchant merchant = merchantService.findMerchantByName(key);
            if (merchant == null) {
                return JsonResult.buildSuccessResult("", null);
            }
            MerchantConfig merchantConfig = merchantService.findConfigByMerchantIdAndConfigName(merchant.getId(), "returnUrl");
            if (merchantConfigReturnUrl == null) {
                return JsonResult.buildSuccessResult("", null);
            }
            String configValue = merchantConfigReturnUrl.split(",")[merchant.getId().intValue()];
            return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "external", "transition", configValue));
        }
        if (StringUtils.isBlank(nextPage)) {
            return JsonResult.buildErrorStateResult("", null);
        }
        return JsonResult.buildSuccessResult("", ImmutableMap.of("type", "user", "transition", nextPage));
    }

}
