package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.BehaviorAuth;
import cn.quantgroup.xyqb.controller.req.v2.ValidateBehavior;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.service.v2.BehaviorContext;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import cn.quantgroup.xyqb.util.IpUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 行为验证的拦截器
 */
public class BehaviorInterceptor implements HandlerInterceptor {

    private final BehaviorContext behaviorContext;

    public BehaviorInterceptor(BehaviorContext behaviorContext) {
        this.behaviorContext = behaviorContext;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {

        String type = request.getHeader(Constants.X_BEHAVIOR_TYPE);
        if (StringUtils.isEmpty(type) || !StringUtils.isNumeric(type)) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            BehaviorAuth behaviorAuth = handlerMethod.getMethodAnnotation(BehaviorAuth.class);
            if (behaviorAuth == null) {
                return true;
            }
        }
        String id = request.getHeader(Constants.X_BEHAVIOR_ID);
        if (StringUtils.isEmpty(id)) {
            throw new BizException(BizExceptionEnum.UN_EXIT_VERIFY_CODE);
        }
        Map<String, String> data = new HashMap<>();
        data.put(Constants.X_BEHAVIOR_ID, id);
        data.put(Constants.X_BEHAVIOR_IP, IpUtil.getRemoteIP(request));
        ValidateBehavior validateBehavior = new ValidateBehavior();

        switch (Integer.parseInt(type)) {
            case 1:
                String challenge = request.getHeader(Constants.X_BEHAVIOR_CHALLENGE);
                String validate = request.getHeader(Constants.X_BEHAVIOR_VALIDATE);
                String secCode = request.getHeader(Constants.X_BEHAVIOR_SECCODE);
                if (StringUtils.isEmpty(challenge) || StringUtils.isEmpty(validate) || StringUtils.isEmpty(secCode)) {
                    throw new BizException(BizExceptionEnum.UN_EXIT_VERIFY_CODE);
                }

                validateBehavior.setType(1);
                data.put(Constants.X_BEHAVIOR_CHALLENGE, challenge);
                data.put(Constants.X_BEHAVIOR_VALIDATE, validate);
                data.put(Constants.X_BEHAVIOR_SECCODE, secCode);

                //走极验逻辑
                break;
            case 2:
                //走量化派图形验证逻辑
                String imageValue = request.getHeader(Constants.X_BEHAVIOR_IMAGEVALUE);
                if (StringUtils.isEmpty(imageValue)) {
                    throw new BizException(BizExceptionEnum.UN_EXIT_VERIFY_CODE);
                }
                validateBehavior.setType(2);
                data.put(Constants.X_BEHAVIOR_IMAGEVALUE, imageValue);
                break;
            default:
                return true;

        }
        validateBehavior.setData(data);
        return behaviorContext.validate(validateBehavior);
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        XyqbSessionContextHolder.releaseSession();
    }
}
