package cn.quantgroup.xyqb.util;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JR58GzipUtil {
  public static String bytesTogzip(byte[] bytes, String encode) {
    if (bytes == null || bytes.length == 0) {
      return null;
    }

    ByteArrayInputStream byteArrayIn = null;
    GZIPInputStream in = null;

    ByteArrayOutputStream byteArrayout = new ByteArrayOutputStream();
    PrintStream out = new PrintStream(byteArrayout);
    try {
      byteArrayIn = new ByteArrayInputStream(bytes);
      in = new GZIPInputStream(byteArrayIn);
      byte[] b = new byte[1024];
      int readlen = 0;
      ;
      while ((readlen = in.read(b)) != -1) {
        out.write(b, 0, readlen);
      }
      out.flush();

    } catch (IOException e) {
      e.printStackTrace();
    } finally {
      try {
        byteArrayIn.close();
        in.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    System.out.println("解密后的数据：");
    return new String(byteArrayout.toByteArray(), Charset.forName(encode));

  }

  public static byte[] gzipTobytes(String str, String encode) {
    if (str == null || str.length() == 0) {
      return null;
    }
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    GZIPOutputStream gzip = null;
    try {
      gzip = new GZIPOutputStream(out);
      gzip.write(str.getBytes(encode));
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      try {
        gzip.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return out.toByteArray();

  }
}

