package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.model.AuthPattern;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * @author xufei on 2018/1/5.
 */
@Data
@Entity
@Table(name = "user_authorized")
public class UserAuthorized {

    @Id
    @Column(name = "id")
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
    private String id;

    @Column(name = "user_uuid")
    private String userUuid;

    //证件号
    @Column(name = "id_no")
    private String idNo;

    @Column(name = "name")
    private String name;

    @Column(name = "auth_pattern")
    private AuthPattern authPattern;

    @Column(name = "available")
    private Boolean available;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    //上一次修改时间
    @Column(name = "updated_at")
    private Timestamp updatedAt;

}
