package cn.quantgroup.xyqb.thirdparty.jcaptcha;

import com.octo.captcha.Captcha;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.util.Locale;

/**
 * 类名称：AbstractManageableImageCaptchaService
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 * 创建时间：15/12/25 13:55
 * 修改人：
 * 修改时间：15/12/25 13:55
 * 修改备注：
 */
public abstract class AbstractManageableImageCaptchaService extends AbstractManageableCaptchaService implements ImageCaptchaService {
    protected AbstractManageableImageCaptchaService(CaptchaStore captchaStore, CaptchaEngine captchaEngine, int minGuarantedStorageDelayInSeconds, int maxCaptchaStoreSize, int captchaStoreLoadBeforeGarbageCollection) {
        super(captchaStore, captchaEngine, minGuarantedStorageDelayInSeconds, maxCaptchaStoreSize, captchaStoreLoadBeforeGarbageCollection);
    }

    public BufferedImage getImageChallengeForID(String ID) throws CaptchaServiceException {
        return (BufferedImage) this.getChallengeForID(ID);
    }

    public BufferedImage getImageChallengeForID(String ID, Locale locale) throws CaptchaServiceException {
        return (BufferedImage) this.getChallengeForID(ID, locale);
    }

    protected Object getChallengeClone(Captcha captcha) {
        BufferedImage challenge = (BufferedImage) captcha.getChallenge();
        BufferedImage clone = new BufferedImage(challenge.getWidth(), challenge.getHeight(), challenge.getType());
        clone.getGraphics().drawImage(challenge, 0, 0, clone.getWidth(), clone.getHeight(), null);
        clone.getGraphics().dispose();
        return clone;
    }


    public abstract long getCustomStoreSize();
}