package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * Created by 11 on 2017/1/17.
 */
@Slf4j
@RestController
@RequestMapping("/wechat")
public class WeChatController {

    // todo: 配置文件
    private static final String TOKEN = "5YihkluEo5QuWAWpFwzvA";

    @Autowired
    private IWechatService wechatService;

    @Autowired
    private IMerchantService merchantService;

    // https://passport.xyqb.com/landing?key=xxx&target=cashTarget5&registerFrom=198&channelId=%d
    @Value("${xyqb-user.ui}")
    private String userUIAddr;



    /**
     * 开发者资质认证,有必要吗?
     *
     * @param request
     * @return
     */
    @RequestMapping("/checkValid")
    public String valid(HttpServletRequest request) {
        String echoStr = request.getParameter("echostr");
        if (checkSignature(request)) {
            return echoStr;
        }
        return "";
    }

    /**
     * 微信登录
     *
     * @param name         姓名
     * @param idNo         身份证号
     * @param phoneNo      手机号
     * @param registerFrom ${registerFrom}
     * @param channelId    ${channelId}
     * @param appChannel   ${appChanel}
     * @param key          "xyqb"
     * @return
     */
    public JsonResult webChatLogin(String name, String idNo, String phoneNo, String registerFrom,
                                   String channelId, String appChannel, String key) {
        if (StringUtils.isBlank(name) || StringUtils.isBlank(idNo) || StringUtils.isBlank(phoneNo)) {
            return JsonResult.buildErrorStateResult("请填写完整的用户信息.", null);
        }
        if (StringUtils.isBlank(key)) {
            return JsonResult.buildErrorStateResult("无效的商户信息.", null);
        }
        return null;
    }


    /**
     * 验签：步骤
     * 1.获取signature, timestamp, nonce三个参数
     * 2.用timestamp, nonce, token三个参数做字符升序排列
     * 3.将排列好的字符串进行sha1加密,和signature参数做比较
     * 4.相等返回true,否则返回false
     *
     * @param request
     * @return
     */
    private boolean checkSignature(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String token = TOKEN;
        String[] arrs = new String[]{token, timestamp, nonce};
        Arrays.sort(arrs);
        String joinStr = joinArray(arrs);
        joinStr = sha1(joinStr);
        return joinStr.equals(signature);
    }

    /**
     * sha1加密算法,
     *
     * @param decript
     * @return 返回40位16进制字符串
     */
    public String sha1(String decript) {
        try {
            MessageDigest digest = java.security.MessageDigest
                    .getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte messageDigest[] = digest.digest();
            StringBuffer hexString = new StringBuffer();
            // 字节数组转换为十六进制数
            for (int i = 0; i < messageDigest.length; i++) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            log.error("未找到sha1算法." + e.getMessage());
        }
        return "";
    }

    /**
     * 数组分割为字符串
     *
     * @param arr
     * @return
     */
    private String joinArray(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for (String str : arr) {
            builder.append(str);
        }
        return builder.toString();
    }

    /**
     * 通过redirect_url获取code
     *
     * @param response
     * @return
     */
    @RequestMapping("/receiveCode/{key}")
    public void receiveCode(String code, @PathVariable(value = "key") String systemKey, HttpServletResponse response) {
        // 从code获取token
        Merchant merchant = merchantService.findMerchantByName(systemKey);

        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
            // todo: 让用户登录，不关联微信, 构造不关联微信的url
            response.setHeader("Location", redirectUrl);
            response.setStatus(301);
            return;
        }
        WechatUserInfo userInfo = wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(), token.getOpenId());
        if (userInfo == null) {
            // todo: 让用户登录，不关联微信, 构造不关联微信的url
            response.setHeader("Location", redirectUrl);
            response.setStatus(301);
            return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
            // todo: 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
            userInfo = wechatService.saveWechatUserInfo(userInfo);
            response.setHeader("Location", redirectUrl);
            response.setStatus(301);
            return;
        }
        if (userInfoInDb.getUserId() == null) {
            // todo: 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
            response.setHeader("Location", redirectUrl);
            response.setStatus(301);
            return;
        }
        // 已经关联了用户
        // todo: create session, 登进去，该怎么玩怎么玩。
        createUserSession(userInfo, merchant);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
    }


}
