package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

import static cn.quantgroup.xyqb.session.XyqbSessionContextHolder.getXSession;
import static cn.quantgroup.xyqb.session.XyqbSessionContextHolder.getXSessionFromRedis;
/**
 * Created by Miraculous on 15/7/5.
 */
public interface IBaseController {

  @Deprecated
  default User getCurrentUser() {
    SessionStruct session = getXSession();
    if (session == null) {
      return null;
    }
    return getXSession().getValues().getUser();
  }

  @Deprecated
  default SessionStruct getSessionStruct() {
    return getXSession();
  }

  default User getCurrentUserFromRedis() {
    SessionStruct session = getXSessionFromRedis();
    if (session == null) {
      return null;
    }
    return session.getValues().getUser();
  }

  default SessionStruct getCurrentSessionFromRedis(){
    return   getXSessionFromRedis();
  }


  default HttpServletRequest getRequest() {
    ServletRequestAttributes attrs = (ServletRequestAttributes) RequestContextHolder
        .getRequestAttributes();
    return attrs.getRequest();
  }

  default String getIp() {
    HttpServletRequest request = getRequest();

    String ip = request.getHeader("x-real-ip");
    if (StringUtils.isEmpty(ip)) {
      ip = request.getRemoteAddr();
    }

    //过滤反向代理的ip
    String[] stemps = ip.split(",");
    if (stemps.length >= 1) {
      //得到第一个IP，即客户端真实IP
      ip = stemps[0];
    }

    ip = ip.trim();
    if (ip.length() > 23) {
      ip = ip.substring(0, 23);
    }

    return ip;
  }

  default String getProtocol() {
    return StringUtils.startsWith(getRequest().getHeader("x-forwarded-proto"), "https") ? "https:" : "http:";
  }
}
