package login;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.external.user.InnerController;
import cn.quantgroup.xyqb.controller.internal.user.UserController;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;


import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by 11 on 2017/1/3.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = Bootstrap.class )
@Slf4j
public class TestUserLogin {

  private MockHttpServletRequest request = new MockHttpServletRequest();;

  @Autowired
  private UserController userController;

  @Autowired
  private InnerController innerController;

  @Test
  public void testBull() {
    String contacts = null;
    boolean notBlank = StringUtils.isNotBlank(contacts);
    System.out.println("-----------------------------result:"+notBlank);

  }
  @Test
  public void testJson() {
    JsonResult addressByUserId = innerController.findAddressByUserId(22L);
  //  JsonResult userByUserId = innerController.findUserByPhoneNo("17811111122");
    System.out.println("-------------result:"+addressByUserId);

  }

    /**
     * 用户密码登陆接口
     */
  @Test
  public void testUserLogin() {
    Long code = 1L;
    String format = String.format(Constants.ZERO_FILL_TEMPLATE, code);
    System.out.println("-----------format:"+format);
    //访问xyqb-user拿到登录token
        Long channelId = 1L;
        String appChannel = "3";
        Long createFrom = 152L;
        //String userId = "8c02a7b8-815f-4ba0-b39c-a9e6e52904de";
        //测试userId为空的情况
        String userId = "";
        request.addHeader("x-original-client-ip", "172.16.0.1");
        request.addHeader("authorization", "Basic MTg1MTMzNDE4MDg6MTIzNDU2");
        JsonResult jsonResult = userController.login(channelId, appChannel, createFrom, userId,"xyqb", request,"xyqb","aaa");
        AuthBean authBean = (AuthBean) jsonResult.getData();
        String token = authBean.getToken();
        System.out.println("user token:" + token);
        //用获取到的token请求xyqb的receive_token

        CloseableHttpClient httpClient =  HttpClients.createDefault();
      HttpPost post = new HttpPost("http://localhost:9004/ex/login/receive_token");

        List<NameValuePair> pairList = new ArrayList<>();
        pairList.add(new BasicNameValuePair("token", token));
        HttpEntity entity = null;
        try {
            entity = new UrlEncodedFormEntity(pairList, "UTF-8");
        }catch (Exception e){
            e.printStackTrace();
        }
        post.setEntity(entity);
        String result = "";
        try {
            CloseableHttpResponse response = httpClient.execute(post);
            result = EntityUtils.toString(response.getEntity());
        } catch (IOException e) {
            e.printStackTrace();
        }
  }

}
