package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.entity.enumerate.EducationEnum;
import cn.quantgroup.xyqb.entity.enumerate.IncomeEnum;
import cn.quantgroup.xyqb.entity.enumerate.IncomeRangeEnum;
import cn.quantgroup.xyqb.entity.enumerate.OccupationEnum;
import lombok.Data;

import java.sql.Timestamp;

/**
 * Created by Miraculous on 2017/2/13.
 */
@Data
public class UserExtInfoRet {
    private static final long serialVersionUID = -1L;

    private Long id;
    private Long userId;
    private IncomeEnum incomeEnum;
    private IncomeRangeEnum incomeRangeEnum;
    private OccupationEnum occupationEnum;
    private EducationEnum educationEnum;
    private boolean hasCar;
    private boolean hasSocialSecurity;
    private boolean hasHouse;
    private boolean hasCreditCard;
    private boolean marryStatus;
    private Long createdAt;
    private Long updateAt;

    public static UserExtInfoRet getUserExtInfoRet(UserExtInfo extInfo) {
        if (extInfo == null) {
            return null;
        }
        UserExtInfoRet ret = new UserExtInfoRet();
        ret.setUserId(extInfo.getUserId());
        ret.setId(extInfo.getId());
        ret.setIncomeEnum(extInfo.getIncomeEnum());
        ret.setIncomeRangeEnum(extInfo.getIncomeRangeEnum());
        ret.setOccupationEnum(extInfo.getOccupationEnum());
        ret.setEducationEnum(extInfo.getEducationEnum());
        ret.setHasCar(extInfo.isHasCar());
        ret.setHasSocialSecurity(extInfo.isHasSocialSecurity());
        ret.setHasHouse(extInfo.isHasHouse());
        ret.setHasCreditCard(extInfo.isHasCreditCard());
        ret.setMarryStatus(extInfo.isMarryStatus());
        ret.setCreatedAt(extInfo.getCreatedAt().getTime());
        ret.setUpdateAt(extInfo.getUpdateAt().getTime());
        return ret;
    }
}
