package cn.quantgroup.xyqb.urora;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
public class UroraAuthenticationToken extends AbstractAuthenticationToken {

    private final Object principal;
    private Object credentials;

    public UroraAuthenticationToken(Object principal) {
        this(principal, null);
    }

    public UroraAuthenticationToken(Object principal, Object credentials) {
        super((Collection) null);
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }



    @Override
    public Object getCredentials() {
        return credentials;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("UroraAuthenticationToken{");
        sb.append("principal=").append(principal);
        sb.append(", credentials=").append(credentials);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}
