package cn.quantgroup.xyqb.util;

import cn.quantgroup.security.AESEncryption;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import org.apache.commons.lang3.StringUtils;

public class AESUtils {

  public static AESEncryption encryption;

  /**
   * V2方法不再考虑历史数据兼容问题
   *
   * @param plainValue 明文
   * @return 密文
   */
  public static String encryptV2(final String plainValue) {
    if (StringUtils.isNotEmpty(plainValue)) {
      return encryption().encryptBase64(plainValue);
    }
    return plainValue;
  }

  /**
   * V2方法不再考虑历史数据兼容问题
   *
   * @param cipherValue 明文
   * @return 密文
   */
  public static String decryptV2(String cipherValue) {
    return StringUtils.isNotEmpty(cipherValue) ? encryption().decryptBase64(cipherValue)
        : cipherValue;
  }

  public static AESEncryption encryption() {
    if (encryption == null) {
      Config config = ConfigService.getAppConfig();
      String key = config.getProperty("encrypt.key", "");
      String iv = config.getProperty("encrypt.iv", "");
      encryption = new AESEncryption(key, iv, true);
    }
    return encryption;
  }
}
