package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class CacheEvictPhoneNoUpdateEventListener implements ApplicationListener<PhoneNoUpdateEvent> {

    @Autowired
    private IUserService userService;

    @Autowired
    private ISessionService sessionService;

    @Override
    public void onApplicationEvent(PhoneNoUpdateEvent event) {
        String oldPhoneNo = event.getOldPhoneNo();
        User user = event.getUser();

        List<SessionStruct> sessionStructList = sessionService.findByUserId(user.getId());
        for (SessionStruct sessionStruct : sessionStructList) {
            SessionValue values = sessionStruct.getValues();
            User sessionUser = values.getUser();
            //修改 session 中的手机号
            sessionUser.setPhoneNo(user.getPhoneNo());
            values.setUser(sessionUser);
        }
        sessionService.persistSession(sessionStructList);

        userService.userCacheEvict(user.getUuid(), oldPhoneNo);
    }
}
