package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * Date: 2019/11/4
 * Time: 上午11:29
 *
 * @author: yangrui
 */
@Data
public class Step1Req {

    /**
     * 注册人真实姓名
     */
    @ApiModelProperty("注册人真实姓名")
    @NotBlank(message = "注册人真实姓名不能为空")
    @Length(max = 50, message = "注册人真实姓名最长50字符")
    private String name;

    /**
     * 注册人身份证件号
     */
    @ApiModelProperty("注册人身份证件号")
    @NotBlank(message = "注册人身份证件号不能为空")
    @Pattern(regexp = UserConstant.ID_CARD_PATTERN, message = "身份证件号格式错误")
    private String idCard;

    /**
     * 当前手机号码
     */
    @ApiModelProperty("当前手机号码")
    @NotBlank(message = "当前手机号码不能为空")
    @Pattern(regexp = UserConstant.MOBILE_PATTERN, message = "当前手机号码格式错误")
    private String prevPhoneNo;

    /**
     * 新手机号码
     */
    @ApiModelProperty("新手机号码")
    @NotBlank(message = "新手机号码不能为空")
    @Pattern(regexp = UserConstant.MOBILE_PATTERN, message = "新手机号码格式错误")
    private String curPhoneNo;

    /**
     * 新手机号码短信验证码
     */
    @ApiModelProperty("新手机号码短信验证码")
    @NotBlank(message = "新手机号码短信验证码不能为空")
    private String smsCode;

    public static ModifyPhoneNo adapt(Step1Req step1Req) {
        ModifyPhoneNo modifyPhoneNo = new ModifyPhoneNo();
        BeanUtils.copyProperties(step1Req, modifyPhoneNo);
        Date date = new Date();
        modifyPhoneNo.setCreateAt(date);
        modifyPhoneNo.setUpdateAt(date);
        return modifyPhoneNo ;
    }
}
