package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step1Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step2Req;
import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import cn.quantgroup.xyqb.repository.IModifyPhoneNoRepository;
import cn.quantgroup.xyqb.service.user.IModifyPhoneNoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * Date: 2019/11/4
 * Time: 下午2:59
 *
 * @author: yangrui
 */
@Slf4j
@Service
public class ModifyPhoneNoServiceImpl implements IModifyPhoneNoService {

    @Resource
    private IModifyPhoneNoRepository modifyPhoneNoRepository;

    /**
     * @param step1Req
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveStep1(Step1Req step1Req) {
        ModifyPhoneNo modifyPhoneNo = Step1Req.adapt(step1Req);
        modifyPhoneNoRepository.saveAndFlush(modifyPhoneNo);
        return modifyPhoneNo.getId();
    }

    /**
     * @param step2Req
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveStep2(Step2Req step2Req) {
        ModifyPhoneNo modifyPhoneNo = modifyPhoneNoRepository.findOne(step2Req.getId());
        modifyPhoneNo.setIdCardFaceUrl(step2Req.getIdCardFaceUrl());
        modifyPhoneNo.setIdCardRearUrl(step2Req.getIdCardRearUrl());
        modifyPhoneNo.setIdCardHoldUrl(step2Req.getIdCardHoldUrl());
    }
}
