package cn.quantgroup.xyqb.service.sms;

import cn.quantgroup.sms.SmsSender;

/**
 * 短信发送服务
 *
 * @author mengfan.feng
 * @time 2015-09-21 11:24
 */
public interface ISmsService {

    SmsSender getSmsSender();

    void sendAfterRegister(String phoneNo);

    void sendAfterRegister(String phoneNo, String contentId);

    /**
     * 验证手机号和验证码是否匹配
     *
     * @param phoneNo          手机号
     * @param verificationCode 验证码（短信/语音）
     * @return
     */
    boolean verifyPhoneAndCode(String phoneNo, String verificationCode);

    /**
     * 是否需要重新发送短信验证码
     *
     * @param phoneNo
     * @return
     */
    boolean needResendCode(String phoneNo);

}
