package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import lombok.Data;

/**
 * Created by xuran on 2017/6/23.
 * 用户统计使用
 */
@Data
public class UserStatistics {
    /**
     * 用户唯一标识
     */
    private String uuid;
    /**
     * 注册渠道号
     */
    private Long registerFrom;
    /**
     * 维度
     * 形如:"app|app名称|平台|应用市场名字"
     * 示例："dimension":"app|shandiandai|IOS|sdd-Appstore"
     */
    private String dimension;
    /**
     * 1-登录
     * 2-注册
     * 3-快捷登录
     * 4-免密登录
     */
    private int action;
    /**
     *
     */
    private Long channel;

    public UserStatistics() {

    }

    public UserStatistics(User user, String dimension, int action, Long channel) {
        this.uuid = user.getUuid();
        this.registerFrom = user.getRegisteredFrom();
        this.action = action;
        this.dimension = dimension;
        this.channel = channel;
    }
}
