package cn.quantgroup.xyqb.event;

import cn.qg.ec.model.base.BusinessEventBaseInfo;
import cn.qg.ec.model.user.UserLoginRegEvent;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.risk.uereventcollecting.UserEventCollectingUtil;
import cn.quantgroup.xyqb.util.encrypt.Md5Util;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/23 18:07
 * @description：风控注册事件
 * @modified By：
 * @version:
 */
@Slf4j
@Component
public class RiskRegisteredEventListener implements ApplicationListener<RegisterEvent> {
    @Override
    public void onApplicationEvent(RegisterEvent registerEvent) {
        UserRegisterParam param =
                registerEvent.getUserRegisterParam();
        User user = param.getUser();
        //拿不到user对象. 就是没注册了
        if (user == null) {
            return;
        }
        UserLoginRegEvent.UserLoginRegEventBuilder builder = UserLoginRegEvent.builder();

        builder.maskPhoneNo(user.getPhoneNo());
        builder.hashPhoneNo(Md5Util.build(Md5Util.build(user.getPhoneNo())));
        builder.subEventType(UserLoginRegEvent.SubEventType.user_only_login);

        BusinessEventBaseInfo.BusinessEventBaseInfoBuilder baseInfoBuilder
                = BusinessEventBaseInfo.builder();

        baseInfoBuilder.userUuid(user.getUuid());
        baseInfoBuilder.channel(String.valueOf(user.getRegisteredFrom()));

        builder.businessEventBaseInfo(baseInfoBuilder.build());

        UserEventCollectingUtil.addEvent(builder.build());
    }
}
