package cn.quantgroup.xyqb.entity;



import cn.quantgroup.xyqb.entity.baseEntity.PartitionEntity;
import cn.quantgroup.xyqb.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: Li JianHua
 * @Date: 2021/9/23
 * @Time: 11:03
 * Description: No Description
 */
@Entity
@Table(name = "product_login")
public class ProductLoginEntity extends PartitionEntity implements Serializable {
    private static final long serialVersionUID = 6495491112527859057L;

    private final static String CLASS_NAME = ProductLoginEntity.class.getSimpleName();

    @Id
    @Column(name = "ID", nullable = false)
    private long id;

    @Column(name = "CUSTOMER_ID", nullable = false)
    private long customerId;

    @Column(name = "CUSTOMER_NAME", nullable = false, length = 255)
    private String customerName;

    @Column(name = "INSTITUTION_ID", nullable = false, length = 4)
    private String institutionId;

    @Column(name = "PHONE_NO", nullable = false, length = 15)
    private String phoneNo;

    @Column(name = "PASSWORD", nullable = true, length = 256)
    private String password;

    @Column(name = "SALT_VALUE", nullable = true, length = 128)
    private String saltValue;

    @Column(name = "STATUS", nullable = false, length = 4)
    private String status;

    @Column(name = "STATUS_DATE", nullable = false)
    private LocalDate statusDate;

    @Column(name = "LAST_STATUS", nullable = true, length = 4)
    private String lastStatus;

    @Column(name = "LAST_LOGIN_TIME", nullable = true)
    private Integer lastLoginTime;

    @Column(name = "BATCH_NO", nullable = true)
    private Integer batchNo;

    @Column(name = "PRODUCT_ID", nullable = false, length = 4)
    private String productId;

    @Column(name = "EXTENSION_ACCOUNT_ID", nullable = true)
    private Long extensionAccountId;

    public long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(long customrId) {
        this.customerId = customrId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSaltValue() {
        return saltValue;
    }

    public void setSaltValue(String saltValue) {
        this.saltValue = saltValue;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalDate getStatusDate() {
        return statusDate;
    }

    public void setStatusDate(LocalDate statusDate) {
        this.statusDate = statusDate;
    }

    public String getLastStatus() {
        return lastStatus;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Integer getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Integer lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Long getExtensionAccountId() {
        return extensionAccountId;
    }

    public void setExtensionAccountId(Long extensionAccountId) {
        this.extensionAccountId = extensionAccountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductLoginEntity that = (ProductLoginEntity) o;
        return customerId == that.customerId && statusDate == that.statusDate&& Objects.equals(customerName, that.customerName) && Objects.equals(institutionId, that.institutionId) && Objects.equals(phoneNo, that.phoneNo) && Objects.equals(password, that.password) && Objects.equals(saltValue, that.saltValue) && Objects.equals(status, that.status) && Objects.equals(lastStatus, that.lastStatus) && Objects.equals(lastLoginTime, that.lastLoginTime) && Objects.equals(productId, that.productId) && Objects.equals(extensionAccountId, that.extensionAccountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(customerId, customerName, institutionId, phoneNo, password, saltValue, status, statusDate, lastStatus, lastLoginTime, productId, extensionAccountId);
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, productId, phoneNo);
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Integer getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Integer batchNo) {
        this.batchNo = batchNo;
    }
}
