package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.exception.NullUserException;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.security.Principal;

/**
 * @author mengfan.feng
 * @time 2015-10-27 11:41
 */
@RestController
@RequestMapping("/app")
public class AppController implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);

    /**
     * 第三方用户登录
     *
     * @param user
     * @return
     */
    @RequestMapping("/login")
    public JsonResult login(Principal user, HttpServletRequest request) {

        if (user == null) {
            throw new NullUserException();
        }

        AuthBean bean = new AuthBean(getRequest().getSession().getId(), user);

        LOGGER.info("第三方用户登录成功, loginFrom:{}, phoneNo:{},appChannel:{}", request.getParameter("registerFrom"), request.getParameter("phoneNo"), getAppChannel());

        return new JsonResult(bean);
    }
}
