package cn.quantgroup.xyqb.service.captcha.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.service.captcha.GeetestLib;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;

/**
 * @author xufei on 2018/1/30.
 */
@Service
public class GeetestCaptchaServiceImpl implements IGeetestCaptchaService {

    @Resource
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Value("${gt.server.status.exist.time}")
    private long gtServerStatusExistTime;

    @Value("${geetest.captcha.id}")
    private String captchaId;

    @Value("${geetest.private.key}")
    private String privateKey;

    @Value("${geetest.new.fail.back}")
    private boolean newFailback;

    @Value("${geetest.api.url}")
    private String apiUrl;

    private GeetestLib getGeetestSdk() {
        return new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
    }

    @Override
    public String fetchGeetestCaptcha(String markStr, String remoteIp, String clientType) {
        GeetestLib gtSdk = new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
        HashMap<String, String> param = getParam(markStr, remoteIp, clientType);

        return gtSdk.getResponseStr(param);
    }

    private HashMap<String, String> getParam(String markStr, String remoteIp, String clientType) {
        HashMap<String, String> param = new HashMap<>();
        param.put("user_id", markStr);
        if (StringUtils.isBlank(clientType)) {
            param.put("client_type", "APP");
        }
        param.put("client_type", clientType);
        param.put("ip_address", remoteIp);
        return param;
    }

    @Override
    public Boolean isCaptchaValidateSuccess(String clientType, String markStr, String remoteIp, String challenge, String validate, String seccode) {
        HashMap<String, String> param = getParam(markStr, remoteIp, clientType);
        return Constants.GT_CAPTCHA_VALIDATE_SUCCESS==getGeetestSdk().enhencedValidateRequest(challenge, validate, seccode, param);
    }
}
