package cn.quantgroup.user.enums;

import lombok.Getter;

/**
 * 用户手机号修改处理状态
 * <p>
 * Date: 2019/11/5
 * Time: 下午2:11
 *
 * @author: yangrui
 */
@Getter
public enum ModifyPhoneNoProcessingStatusEnum {
    /**
     * 待人工处理
     */
    INIT(0, "待人工处理"),
    /**
     * 待用户反馈
     */
    WAIT_4_USER_FEEDBACK(1, "待用户反馈"),
    /**
     * 已反馈
     */
    DONE(2, "已反馈");

    /**
     * 类型
     */
    private int ordinal;

    /**
     * 描述
     */
    private String desc;

    ModifyPhoneNoProcessingStatusEnum(int ordinal, String desc) {
        this.ordinal = ordinal;
        this.desc = desc;
    }
}
