package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.jr58.Jr58RegisterParam;
import cn.quantgroup.xyqb.model.jr58.Jr58RegisterResult;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;


/**
 * @author mengfan.feng
 * @time 2015-08-19 18:20
 */
@Service
public class LkbUserviceImpl implements ILkbUserService {

  private static final Logger LOGGER = LoggerFactory.getLogger(LkbUserviceImpl.class);

  private static final String TOKEN_PATTERN = "timeunit=%sappkey=lkb010203#$%%";

  @Autowired
  private IHttpService httpService;

  @Value("${lkb.client.url}")
  private String clientUrl;

  @Value("${lkb.client.user.register.app}")
  private String registerApp;

  @Value("${lkb.client.user.register.58jr}")
  private String register58jr;

  @Value("${lkb.client.user.update}")
  private String userUpdate;

  @Override
  public String registerApp(String phoneNo, String password) {
    String timeunit = System.currentTimeMillis() + "";
    String token = PasswordUtil.MD5(String.format(TOKEN_PATTERN, timeunit));

    Map<String, String> parameters = ImmutableMap.<String, String>builder()
        .put("appId", Constants.Channel.LKB_CODE)
        .put("timeunit", timeunit)
        .put("token", token)
        .put("userName", phoneNo)
        .put("password", password)
        .build();

    String response = httpService.get(clientUrl + registerApp, parameters);
    //Map<String, String> result = GSON.fromJson(response, Map.class);
    Map<String, String> result = JSONObject.parseObject(response, Map.class);
    if (result == null || "0".equals(result.get("flag"))) {
      LOGGER.warn("向LKB注册用户失败, phoneNo:{}, password:{}", phoneNo, password);
      return "";
    }
    return result.get("uid");
  }

  @Override
  public Jr58RegisterResult registerJr58(Jr58RegisterParam param) {
    Map<String, String> parameters = ImmutableMap.<String, String>builder()
        .put("wbId", param.getWbId())
        .put("customerId", param.getCustomerId())
        .put("name", param.getName())
        .put("idcard", param.getIdcard())
        .put("email", StringUtils.substring(param.getEmail(), 0, 30))
        .put("phone", param.getPhone())
        .build();

    String response = httpService.get(clientUrl + register58jr, parameters);
    //return GSON.fromJson(response, Jr58RegisterResult.class);
    return JSONObject.parseObject(response, Jr58RegisterResult.class);
  }

  @Override
  @Async
  public void userUpdate(String uuid, String name, String idNo) {
    Map<String, String> parameters = ImmutableMap.<String, String>builder()
        .put("userId", uuid)
        .put("realName", name)
        .put("idcard", idNo)
        .build();

    String response = httpService.get(clientUrl + userUpdate, parameters);
    //Map<String, String> result = GSON.fromJson(response, Map.class);
    Map<String, String> result = JSONObject.parseObject(response, Map.class);
    if (result == null || "false".equals(result.get("flag"))) {
      LOGGER.warn("向LKB-Client同步用户信息失败, result: {}", result);
    }
  }
}
