package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service
public class UserServiceImpl implements IUserService {

  @Autowired
  RedisTemplate<String, String> stringRedisTemplate;

  @Autowired
  private ILkbUserService lkbUserService;

  @Autowired
  private IUserRepository userRepository;

  @Autowired
  private ISmsService smsService;

  @Override
  public User findByPhoneInDb(String phone) {
    return userRepository.findByPhoneNo(phone);
  }

  @Override
  public User findByUuidInDb(String uuid) {
    return userRepository.findByUuid(uuid);
  }

  @Override
  public User saveUser(User user) {
    return userRepository.save(user);
  }

  @Override
  public User findById(Long userId) {
    return userRepository.findById(userId);
  }


  @Override
  public User registerAndReturn(String phoneNo, String password, Long registerFrom) {
    String uuid = lkbUserService.registerApp(phoneNo, password);
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());

    User user = new User();
    user.setEnable(true);
    user.setPhoneNo(phoneNo);
    user.setUpdatedAt(currentTime);
    user.setCreatedAt(currentTime);
    user.setUuid(uuid);
    user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
    user.setRegisteredFrom(registerFrom);

    return userRepository.save(user);
  }


  @Override
  @Cacheable(value = "usercache", key = "'xyqbuser' + #phone", unless = "#result == null", cacheManager = "cacheManager")
  public User findByPhoneWithCache(String phone) {
    return userRepository.findByPhoneNo(phone);
  }

  @Override
  @Cacheable(value = "usercache", key = "'xyqbuser' + #uuid", unless = "#result == null", cacheManager = "cacheManager")
  public User findByUuidWithCache(String uuid) {
    return userRepository.findByUuid(uuid);
  }

  @Override
  @Transactional(value = Transactional.TxType.REQUIRED)
  public boolean register(String phoneNo, String password, Long registerFrom, String userIp, Long channelId) {
    String uuid = lkbUserService.registerApp(phoneNo, password);
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());

    User user = new User();
    user.setEnable(true);
    user.setPhoneNo(phoneNo);
    user.setUpdatedAt(currentTime);
    user.setCreatedAt(currentTime);
    user.setUuid(uuid);
    user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
    //解决线上白条registerFrom为1的问题
    if (channelId == 222L) {
      user.setRegisteredFrom(channelId);
    } else {
      user.setRegisteredFrom(registerFrom);
    }
    //user.setRegisteredFrom(registerFrom);

    user = userRepository.save(user);
    smsService.sendAfterRegister(phoneNo);
    return user != null;
  }

  @Override
  public boolean exist(String phoneNo) {
    return userRepository.findByPhoneNo(phoneNo) != null;
  }

  /**
   * 修改用户密码
   *
   * @param phoneNo
   * @param password
   * @return
   * @date 2017-02-15 修改用户修改密码时，更新updatedAt时间
   */
  @Override
  @CacheEvict(value = "usercache", key = "'xyqbuser' + #phone", cacheManager = "cacheManager")
  public boolean resetPassword(String phoneNo, String password) {

    User user = userRepository.findByPhoneNo(phoneNo);
    if (user == null) {
      throw new RuntimeException("用户[" + phoneNo + "]不存在");
    }
    user.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
    user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
    user = userRepository.save(user);
    stringRedisTemplate.expire("usercache:xyqbuser" + phoneNo, 1L, TimeUnit.MILLISECONDS);
    return StringUtils.equals(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT), user.getPassword());

  }
}
