package cn.quantgroup.xyqb.model.sms;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * 短信模板适配枚举类
 *
 * @author renwc
 * @date 2018-04-23
 */
@Slf4j
public enum SmsMerchant {
    DEFAULT(1, 1, "默认：函谷关"),
    HAN_GU_GUAN(1, 1, "函谷关"),
    PAY_CENTER(2, 1, "支付中心"),
    XIN_YONG_QIAN_BAO(3, 1, "信用钱包"),
    DI_TING(4, 1, "谛听"),
    BAI_TIAO_OFFLINE(5, 1, "线下白条"),
    DB_FLOW_ALLIANCE(6, 1, "【数据部】流量联盟"),
    BAI_TIAO_MALL(7, 1, "白条商城"),
    BAI_TIAO(8, 1, "白条"),
    OPS_ALARM(9, 1, "运维告警"),
    OPERATION_PLATFORM(10, 1, "运营平台"),
    SUB_MENU(11, 1, "分单"),
    RED_PACKET(12, 1, "红包系统"),
    DATA_VISUAL(13, 1, "数据可视化平台+运营"),
    CAPITAL_OPERATING(14, 1, "资金运营系统"),
    COLLECTION(15, 1, "催收"),
    BAI_TIAO_COMMON(16, 1, "通用白条"),
    CIRCULATION_QUOTA(17, 1, "外部循环额度"),
    FLYING_COW_TO_BORROW(18, 5033, "飞牛贷"),
    VCC(20, 5108, "VCC-真享花,vcc-talos"),
    ZXH(20, 5337, "信用钱包马甲包");

    private int merchantId;
    private int contentId;
    private String desc;

    SmsMerchant(int merchantId, int contentId, String desc) {
        this.merchantId = merchantId;
        this.contentId = contentId;
        this.desc = desc;
    }

    /**
     * 获取短信模板id
     *
     * @return
     */
    public String getMerchantId() {
        return String.valueOf(this.merchantId);
    }

    /**
     * 获取短信contentId
     *
     * @return
     */
    public String getContentId() {
        return String.valueOf(this.contentId);
    }

    /**
     * 根据name实例化枚举值
     * 无匹配项时返回默认枚举值
     *
     * @param name
     * @return
     */
    public static SmsMerchant of(String name) {
        if (StringUtils.isBlank(name)) {
            return DEFAULT;
        }
        SmsMerchant merchant = null;
        try {
            merchant = SmsMerchant.valueOf(name.toUpperCase());
        } catch (Exception e) {
            log.warn("短信模板适配类型:[非法值]:{}", name, e);
            merchant = DEFAULT;
        }
        return merchant;
    }
}
