package cn.quantgroup.xyqb.aspect.logcaller;

import cn.quantgroup.xyqb.util.IpUtil;
import com.google.common.base.Stopwatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * 调用者记录
 * Created by Administrator on 2017/5/15.
 */
@Aspect
@Component
@Order(value = Ordered.HIGHEST_PRECEDENCE)
public class LogCallHttpAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogCallHttpAspect.class);

    @Pointcut(value = "execution(public * cn.quantgroup.xyqb.controller..*.*(..)) " +
            "&& !execution(* cn.quantgroup.xyqb.controller.ExceptionHandlingController.*(..))")
    private void logHttpCaller() {
    }

    @Around("logHttpCaller()")
    public Object record(ProceedingJoinPoint pjp) throws Throwable {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ServletRequestAttributes attrs = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attrs.getRequest();
        String remoteIP = IpUtil.getRemoteIP(request);
        Object[] args = pjp.getArgs();
        boolean hasException = false;
        Object result;
        try {
            result = pjp.proceed();
        } catch (Throwable e) {
            hasException = true;
            throw e;
        } finally {
            Stopwatch stop = stopwatch.stop();
            long elapsed = stop.elapsed(TimeUnit.MILLISECONDS);
            LOGGER.info("[httpRequestLog],url:[{}],remoteIP:[{}],args:[{}],duration:[{}],exception:[{}]",
                    request.getRequestURL(), remoteIP, args, elapsed, hasException);
        }
        return result;
    }
}
