package cn.quantgroup.xyqb.aspect.accessable;

import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.util.IPUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.xml.crypto.dsig.keyinfo.PGPData;

/**
 * Created by 11 on 2017/3/23.
 */
@Aspect
@Component
public class IpValidatorAdvisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpValidatorAdvisor.class);

    /*@Value("${config.accessable}")
    private boolean accessable;*/

    @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.accessable.IpValidator)")
    private void needIpValidate() {
    }

    @Around("needIpValidate()")
    private Object doCapchaValidate(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = IPUtil.getRemoteIP(request);
        LOGGER.info("获取ip地址:" + ip);
        if(ip.startsWith("172")||ip.startsWith("192")){
            return pjp.proceed();
        } else {
            LOGGER.error("非法ip:{}", ip);
            return JsonResult.buildErrorStateResult("非法ip", null);
        }
        /*HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = IPUtil.getRemoteIP(request);
        if(accessable) {
            return pjp.proceed();
        } else {
            if(ip.startsWith("172")){
                return pjp.proceed();
            } else {
                LOGGER.error("非法ip:{}", ip);
                return JsonResult.buildErrorStateResult("非法ip", null);
            }
        }*/
        //return pjp.proceed();
    }
}
