package cn.quantgroup.xyqb.service.session;

import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.function.OneArgFunction;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;

/**
 * Created by 11 on 2016/12/28.
 */
public interface ISessionService {
    SessionStruct createSessionAndPersistInCache(User user, Merchant merchant);


    SessionStruct createSessionAndPersist(User user, OneArgFunction<SessionStruct> beforPersist, Merchant merchant);

    String findSessionIdByUserIdAndMerchant(Long userId, Merchant merchant);
    String findSessionValueBySessionId(String sessionId);
    SessionStruct newSession(User user);
    void persistSession(String token, SessionValue sessionValue);

    SessionStruct findSessionBySessionId(String sessionId);
}
