package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.xyqb.model.sms.SmsResult;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.sms.ISmsSender;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

import static cn.quantgroup.xyqb.model.sms.SmsConfig.SMS.CHUANG_LAN;

/**
 * <pre>
 * 创蓝短信平台
 * 短信提交响应分为两行，第一行为响应时间和状态，第二行为服务器给出提交msgid。
 * 无论发送的号码是多少，一个发送请求只返回一个msgid，如果响应的状态不是“0”，则没有msgid即第二行数据。
 * （每行以换行符(0x0a,即\n)分割）
 * 0	提交成功
 * 101	无此用户
 * 102	密码错
 * 103	提交过快（提交速度超过流速限制）
 * 104	系统忙（因平台侧原因，暂时无法处理提交的短信）
 * 105	敏感短信（短信内容包含敏感词）
 * 106	消息长度错（>536或<=0）
 * 107	包含错误的手机号码
 * 108	手机号码个数错（群发>50000或<=0;单发>200或<=0）
 * 109	无发送额度（该用户可用短信数已使用完）
 * 110	不在发送时间内
 * 111	超出该账户当月发送额度限制
 * 112	无此产品，用户没有订购该产品
 * 113	extno格式错（非数字或者长度不对）
 * 115	自动审核驳回
 * 116	签名不合法，未带签名（用户必须带签名的前提下）
 * 117	IP地址认证错,请求调用的IP地址不是系统登记的IP地址
 * 118	用户没有相应的发送权限
 * 119	用户已过期
 * </pre>
 *
 * @author mengfan.feng
 * @time 2015-09-14 14:36
 */
@Service
public class ChuangLanSms implements ISmsSender {

    private static final Map<String, String> ERRORS = ImmutableMap.<String, String>builder()
            .put("0", "提交成功")
            .put("101", "无此用户")
            .put("102", "密码错")
            .put("103", "提交过快（提交速度超过流速限制）")
            .put("104", "系统忙（因平台侧原因，暂时无法处理提交的短信）")
            .put("105", "敏感短信（短信内容包含敏感词）")
            .put("106", "消息长度错（>536或<=0）")
            .put("107", "包含错误的手机号码")
            .put("108", "手机号码个数错（群发>50000或<=0;单发>200或<=0）")
            .put("109", "无发送额度（该用户可用短信数已使用完）")
            .put("110", "不在发送时间内")
            .put("111", "超出该账户当月发送额度限制")
            .put("112", "无此产品，用户没有订购该产品")
            .put("113", "extno格式错（非数字或者长度不对）")
            .put("115", "自动审核驳回")
            .put("116", "签名不合法，未带签名（用户必须带签名的前提下）")
            .put("117", "IP地址认证错,请求调用的IP地址不是系统登记的IP地址")
            .put("118", "用户没有相应的发送权限")
            .put("119", "用户已过期")
            .build();

    @Autowired
    private IHttpService httpService;

    @Override
    public SmsResult send(String phone, String content) {

        Map<String, String> parameters = ImmutableMap.<String, String>builder()
                .put("account", CHUANG_LAN.getAccount())
                .put("pswd", CHUANG_LAN.getPassword())
                .put("needstatus", "true")
                .put("mobile", phone)
                .put("msg", content)
                .build();

        String response = httpService.get(CHUANG_LAN.getUrl(), parameters);

        if (StringUtils.isBlank(response)) {
            return SmsResult.error("创蓝短信平台，返回结果为空");
        }

        String line1[] = response.split("\n")[0].split(",");
        String code = line1[1];

        if ("0".equals(code)) {
            return SmsResult.success();
        }
        return SmsResult.error(ERRORS.get(code));
    }
}
