package cn.quantgroup.xyqb.thirdparty.jcaptcha;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.CaptchaQuestionHelper;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.gimpy.GimpyFactory;

import java.awt.image.BufferedImage;
import java.util.Locale;

/**
 * 类名称：CustomGimpyFactory
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 *          创建时间：15/12/17 08:42
 *          修改人：
 *          修改时间：15/12/17 08:42
 *          修改备注：
 */
public class CustomGimpyFactory extends GimpyFactory {

    public CustomGimpyFactory(WordGenerator generator, WordToImage word2image) {
        super(generator, word2image);
    }

    @Override
    public ImageCaptcha getImageCaptcha(Locale locale) {
        Integer wordLength = this.getRandomLength();
        String word = this.getWordGenerator().getWord(wordLength, locale);
        BufferedImage image = null;

        try {
            image = this.getWordToImage().getImage(word);
        } catch (Throwable var6) {
            throw new CaptchaException(var6);
        }

        return new SimpleCaptcha(CaptchaQuestionHelper.getQuestion(locale, BUNDLE_QUESTION_KEY), image, word);
    }
}
